/****************************************************************************
* NAME:         mmc_drv.c
*****************************************************************************/

/*_____ I N C L U D E S ____________________________________________________*/

#include "mmc_drv.h"                        /* mmc driver definition */

/*_____ M A C R O S ________________________________________________________*/

/*_____ D E F I N I T I O N ________________________________________________*/

static ULONG arg;

/*_____ D E C L A R A T I O N ______________________________________________*/

void    mmc_send_cmd (BYTE, ULONG, BYTE);
BYTE    mmc_check_response (void);

/****************************************************************************
* NAME: mmc_send_cmd
*----------------------------------------------------------------------------
* PARAMS:
*   index:    command index
*   argument: argument (32 bits) of the command to send
*   response: expected response to the command to send
* return:
*----------------------------------------------------------------------------
* PURPOSE:
*   Send a command on the bus
*****************************************************************************/
void mmc_send_cmd (BYTE index, ULONG argument, BYTE response)
{
  
  while((MMSTA & MSK_CFLCK)!=0);        // wait for lock...
  
  MMCMD = index;
  MMCMD = ((BYTE*)&argument)[0];
  MMCMD = ((BYTE*)&argument)[1];
  MMCMD = ((BYTE*)&argument)[2];
  MMCMD = ((BYTE*)&argument)[3];

  switch (response)
  {
    case MMC_RESP_R1:
    case MMC_RESP_R4:
    case MMC_RESP_R5:
    {
      MMCON0 |= MSK_RFMT;                   /* set 48 bits response */
      MMCON0 &= ~MSK_CRCDIS;                /* set response with CRC7 */
      MMCON1 |= (MSK_CMDEN|MSK_RESPEN);
      MMCON1 &= ~(MSK_CMDEN|MSK_RESPEN);    /* send command with response */
      break;
    }
    case MMC_RESP_R2:
    {
      MMCON0 &= ~(MSK_RFMT | MSK_CRCDIS);   /* set 136 bits response with CRC7 */
      MMCON1 |= (MSK_CMDEN|MSK_RESPEN);
      MMCON1 &= ~(MSK_CMDEN|MSK_RESPEN);    /* send command with response */
      break;
    }
    case MMC_RESP_R3:
    {
      MMCON0 |= (MSK_RFMT | MSK_CRCDIS);    /* set 48 bits response without CRC7 */
      MMCON1 |= (MSK_CMDEN|MSK_RESPEN);
      MMCON1 &= ~(MSK_CMDEN|MSK_RESPEN);    /* send command with response */
      break;
    }
    case MMC_NO_RESP:
    default:
    {
      MMCON1 |= MSK_CMDEN;
      MMCON1 &= ~MSK_CMDEN;                 /* send command without response */
      break;
    }
  }
}


/****************************************************************************
* NAME: mmc_send_scmd
*----------------------------------------------------------------------------
* PARAMS:
*   index:    command index
*   response: expected response to the command to send
* return:
*----------------------------------------------------------------------------
* PURPOSE:
*   Send a short command on the bus
*****************************************************************************/
void mmc_send_scmd (BYTE index, BYTE response)
{
  
  while((MMSTA & MSK_CFLCK)!=0);        // wait for lock...
  
  MMCMD = index;
  MMCMD = (BYTE)MMC_NO_ARG;
  MMCMD = (BYTE)MMC_NO_ARG;
  MMCMD = (BYTE)MMC_NO_ARG;
  MMCMD = (BYTE)MMC_NO_ARG;

  switch (response)
  {
    case MMC_RESP_R1:
    case MMC_RESP_R4:
    case MMC_RESP_R5:
    case SD_RESP_R6:
    {
      MMCON0 |= MSK_RFMT;                   /* set 48 bits response */
      MMCON0 &= ~MSK_CRCDIS;                /* set response with CRC7 */
      MMCON1 |= (MSK_CMDEN|MSK_RESPEN);
      MMCON1 &= ~(MSK_CMDEN|MSK_RESPEN);    /* send command with response */
      break;
    }
    case MMC_RESP_R2:
    {
      MMCON0 &= ~(MSK_RFMT | MSK_CRCDIS);   /* set 136 bits response with CRC7 */
      MMCON1 |= (MSK_CMDEN|MSK_RESPEN);
      MMCON1 &= ~(MSK_CMDEN|MSK_RESPEN);    /* send command with response */
      break;
    }
    case MMC_RESP_R3:
    {
      MMCON0 |= (MSK_RFMT | MSK_CRCDIS);    /* set 48 bits response without CRC7 */
      MMCON1 |= (MSK_CMDEN|MSK_RESPEN);
      MMCON1 &= ~(MSK_CMDEN|MSK_RESPEN);    /* send command with response */
      break;
    }
    case MMC_NO_RESP:
    default:
    {
      MMCON1 |= MSK_CMDEN;
      MMCON1 &= ~MSK_CMDEN;                 /* send command without response */
      break;
    }
  }
}


